function [Pos,NewMin,NewMax]= MinEnergy(handles)
% Restricts the position of the Slider to the Energy range in case several energy slices are added up (see DispRange). 

%% Get Handles
MaxMin    = get(handles.Slider, 'UserData');
EnergyRes = get(handles.Slider, 'SliderStep');
NewMax    = str2double(get(handles.MaxEnergy, 'String'));
NewMin    = str2double(get(handles.MinEnergy, 'String'));
OldEnergy = str2double(get(handles.DispEnergy,'String'));
DispRange = str2double(get(handles.DispRange,'String'));

%% Calculate
EnergyRes = EnergyRes(1);
DispRange = (DispRange-EnergyRes)/2;

TotalMin  = MaxMin(2);
if NewMin - DispRange < TotalMin
    NewMin = TotalMin + DispRange;
elseif NewMin > NewMax
    NewMin = NewMax;
end
Pos = OldEnergy;
if  Pos<NewMin
    Pos=NewMin;
elseif Pos>NewMax
    Pos=NewMax;
end
clearvars -except Pos NewMin NewMax
end